<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\WorkExperienceModel;

class WorkController extends BaseController
{
    protected $workModel;

    public function __construct()
    {
        $this->workModel = new WorkExperienceModel();
    }

    public function index()
    {
        $search = $this->request->getGet('search') ?? '';
        $filter = [
            'tahun_mulai' => $this->request->getGet('tahun_mulai') ?? '',
            'tahun_selesai' => $this->request->getGet('tahun_selesai') ?? ''
        ];
        $sort = $this->request->getGet('sort') ?? 'urutan';
        $order = $this->request->getGet('order') ?? 'ASC';
        $page = (int)($this->request->getGet('page') ?? 1);

        $builder = $this->workModel->searchAndFilter($search, $filter, $sort, $order);
        $total = $builder->countAllResults(false);
        
        $work = $builder->get(10, ($page - 1) * 10)->getResultArray();

        $pager = \Config\Services::pager();
        $pager->store('work', $page, 10, $total);

        $data = [
            'title' => 'Kelola Pengalaman Kerja',
            'work' => $work,
            'pager' => $pager,
            'search' => $search,
            'filter' => $filter,
            'sort' => $sort,
            'order' => $order
        ];

        return view('admin/work/index', $data);
    }

    public function create()
    {
        $data = [
            'title' => 'Tambah Pengalaman Kerja'
        ];
        return view('admin/work/create', $data);
    }

    public function store()
    {
        $rules = [
            'nama_perusahaan' => 'required|min_length[3]|max_length[200]',
            'posisi' => 'required|min_length[3]|max_length[200]'
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $data = [
            'nama_perusahaan' => $this->request->getPost('nama_perusahaan'),
            'posisi' => $this->request->getPost('posisi'),
            'tahun_mulai' => $this->request->getPost('tahun_mulai'),
            'tahun_selesai' => $this->request->getPost('tahun_selesai'),
            'deskripsi' => $this->request->getPost('deskripsi'),
            'urutan' => (int)($this->request->getPost('urutan') ?? 0)
        ];

        if ($this->workModel->insert($data)) {
            return redirect()->to('admin/work')->with('success', 'Pengalaman kerja berhasil ditambahkan!');
        } else {
            return redirect()->back()->withInput()->with('error', 'Gagal menambahkan pengalaman kerja!');
        }
    }

    public function edit($id)
    {
        $work = $this->workModel->find($id);
        
        if (!$work) {
            return redirect()->to('admin/work')->with('error', 'Pengalaman kerja tidak ditemukan!');
        }

        $data = [
            'title' => 'Edit Pengalaman Kerja',
            'work' => $work
        ];
        return view('admin/work/edit', $data);
    }

    public function update($id)
    {
        $work = $this->workModel->find($id);
        
        if (!$work) {
            return redirect()->to('admin/work')->with('error', 'Pengalaman kerja tidak ditemukan!');
        }

        $rules = [
            'nama_perusahaan' => 'required|min_length[3]|max_length[200]',
            'posisi' => 'required|min_length[3]|max_length[200]'
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $data = [
            'nama_perusahaan' => $this->request->getPost('nama_perusahaan'),
            'posisi' => $this->request->getPost('posisi'),
            'tahun_mulai' => $this->request->getPost('tahun_mulai'),
            'tahun_selesai' => $this->request->getPost('tahun_selesai'),
            'deskripsi' => $this->request->getPost('deskripsi'),
            'urutan' => (int)($this->request->getPost('urutan') ?? 0)
        ];

        if ($this->workModel->update($id, $data)) {
            return redirect()->to('admin/work')->with('success', 'Pengalaman kerja berhasil diupdate!');
        } else {
            return redirect()->back()->withInput()->with('error', 'Gagal mengupdate pengalaman kerja!');
        }
    }

    public function delete($id)
    {
        $work = $this->workModel->find($id);
        
        if (!$work) {
            return redirect()->to('admin/work')->with('error', 'Pengalaman kerja tidak ditemukan!');
        }

        if ($this->workModel->delete($id)) {
            return redirect()->to('admin/work')->with('success', 'Pengalaman kerja berhasil dihapus!');
        } else {
            return redirect()->to('admin/work')->with('error', 'Gagal menghapus pengalaman kerja!');
        }
    }
}


